#include <iostream>
using namespace std;

int matrica[1000][1000];
pair<int, int> top_left_dp[1000][1000];
pair<int, int> bottom_right_dp[1000][1000];

void print_matrix(int n, int m)
{
	for (int i = 0; i < n; i++)
	{
		for (int j = 0; j < m; j++)
		{
			cout << bottom_right_dp[i][j].first << "," << bottom_right_dp[i][j].second << " ";
		}
		cout << "\n";
	}
}

int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(0);

	int n, m, q;
	cin >> n >> m >> q;
	for (int i = 0; i < n; i++)
	{
		for (int j = 0; j < m; j++)
		{
			cin >> matrica[i][j];
		}
	}

	///////////// Top right corner
	// Base cases
	top_left_dp[0][0] = pair<int, int>(matrica[0][0], 1);
	// Column
	for (int i = 1; i < n; i++)
	{
		int infected = matrica[i][0];
		int last_infected = top_left_dp[i - 1][0].first;
		int last_min = top_left_dp[i - 1][0].second;
		if (last_infected == infected)
		{
			top_left_dp[i][0] = pair<int, int>(infected, last_min + 1);
		}
		else
		{
			if (infected < last_infected)
			{
				top_left_dp[i][0] = pair<int, int>(infected, 1);
			}
			else
			{
				top_left_dp[i][0] = pair<int, int>(last_infected, last_min);
			}
		}
	}
	// Row
	for (int i = 1; i < m; i++)
	{
		int infected = matrica[0][i];
		int last_infected = top_left_dp[0][i - 1].first;
		int last_min = top_left_dp[0][i - 1].second;
		if (last_infected == infected)
		{
			top_left_dp[0][i] = pair<int, int>(infected, last_min + 1);
		}
		else
		{
			if (infected < last_infected)
			{
				top_left_dp[0][i] = pair<int, int>(infected, 1);
			}
			else
			{
				top_left_dp[0][i] = pair<int, int>(last_infected, last_min);
			}
		}
	}

	// Dynamic programming
	for (int i = 1; i < n; i++)
	{
		for (int j = 1; j < m; j++)
		{
			auto up = top_left_dp[i - 1][j];
			auto left = top_left_dp[i][j - 1];
			auto intersection = top_left_dp[i - 1][j - 1];
			auto current = pair<int, int>();

			if (up.first != left.first)
			{
				if (up.first < left.first)
				{
					current.first = up.first;
					current.second = up.second;
				}
				else
				{
					current.first = left.first;
					current.second = left.second;
				}
			}
			else
			{
				current.first = up.first;
				if (intersection.first == up.first)
				{
					current.second = up.second + left.second - intersection.second;
				}
				else
				{
					current.second = up.second + left.second;
				}
			}

			if (matrica[i][j] != current.first)
			{
				if (matrica[i][j] < current.first)
				{
					current.first = matrica[i][j];
					current.second = 1;
				}
			}
			else
				current.second++;

			top_left_dp[i][j] = current;
		}
	}


	//////////////// Bottom right
	// Base cases
	bottom_right_dp[n - 1][m - 1] = pair<int, int>(matrica[n - 1][m - 1], 1);

	// Column
	for (int i = n - 2; i >= 0; i--)
	{
		int infected = matrica[i][m - 1];
		int last_infected = bottom_right_dp[i + 1][m - 1].first;
		int last_min = bottom_right_dp[i + 1][m - 1].second;
		if (last_infected == infected)
		{
			bottom_right_dp[i][m - 1] = pair<int, int>(infected, last_min + 1);
		}
		else
		{
			if (infected < last_infected)
			{
				bottom_right_dp[i][m - 1] = pair<int, int>(infected, 1);
			}
			else
			{
				bottom_right_dp[i][m - 1] = pair<int, int>(last_infected, last_min);
			}
		}
	}

	
	// Row
	for (int i = m - 2; i >= 0; i--)
	{
		int infected = matrica[n - 1][i];
		int last_infected = bottom_right_dp[n - 1][i + 1].first;
		int last_min = bottom_right_dp[n - 1][i + 1].second;
		if (last_infected == infected)
		{
			bottom_right_dp[n - 1][i] = pair<int, int>(infected, last_min + 1);
		}
		else
		{
			if (infected < last_infected)
			{
				bottom_right_dp[n - 1][i] = pair<int, int>(infected, 1);
			}
			else
			{
				bottom_right_dp[n - 1][i] = pair<int, int>(last_infected, last_min);
			}
		}
	}

	// Dynamic programming

	for (int i = n - 2; i >= 0; i--)
	{
		for (int j = m - 2; j >= 0; j--)
		{
			auto down = bottom_right_dp[i + 1][j];
			auto right = bottom_right_dp[i][j + 1];
			auto intersection = bottom_right_dp[i + 1][j + 1];
			auto current = pair<int, int>();

			if (down.first != right.first)
			{
				if (down.first < right.first)
				{
					current.first = down.first;
					current.second = down.second;
				}
				else
				{
					current.first = right.first;
					current.second = right.second;
				}
			}
			else
			{
				current.first = down.first;
				if (intersection.first == down.first)
				{
					current.second = down.second + right.second - intersection.second;
				}
				else
				{
					current.second = down.second + right.second;
				}
			}

			if (matrica[i][j] != current.first)
			{
				if (matrica[i][j] < current.first)
				{
					current.first = matrica[i][j];
					current.second = 1;
				}
			}
			else
				current.second++;

			bottom_right_dp[i][j] = current;
		}
	}

	for (int t = 0; t < q; t++)
	{
		int i, j, h, w;
		cin >> i >> j >> h >> w;
		i--; j--; h--; w--;
		int top_right_i = i;
		int top_right_j = j + w;
		int bottom_left_i = i + h;
		int bottom_left_j = j;

		auto current1 = pair<int, int>();

		if (top_right_i - 1 >= 0 && bottom_left_j - 1 >= 0)
		{
			auto right = top_left_dp[top_right_i - 1][top_right_j];
			auto down = top_left_dp[bottom_left_i][bottom_left_j - 1];
			auto intersection1 = top_left_dp[i - 1][j - 1];
			

			if (right.first == down.first)
			{
				current1.first = right.first;
				if (intersection1.first == right.first)
				{
					current1.second = right.second + down.second - intersection1.second;
				}
				else
				{
					current1.second = right.second + down.second;
				}
			}
			else
			{
				if (right.first < down.first)
				{
					current1.first = right.first;
					current1.second = right.second;
				}
				else
				{
					current1.first = down.first;
					current1.second = down.second;
				}
			}
		}
		else if (top_right_i - 1 < 0 && bottom_left_j - 1 >= 0)
		{
			auto down = top_left_dp[bottom_left_i][bottom_left_j - 1];
			current1.first = down.first;
			current1.second = down.second;
		}
		else if (top_right_i - 1 >= 0 && bottom_left_j - 1 < 0)
		{
			auto right = top_left_dp[top_right_i - 1][top_right_j];
			current1.first = right.first;
			current1.second = right.second;
		}
		else
		{
			current1.first = -1;
			current1.second = -1;
		}


		auto current2 = pair<int, int>();
		if (top_right_j + 1 < m && bottom_left_i + 1 < n)
		{
			auto up = bottom_right_dp[0][top_right_j + 1];
			auto left = bottom_right_dp[bottom_left_i + 1][0];
			auto intersection2 = bottom_right_dp[bottom_left_i + 1][top_right_j + 1];

			if (up.first == left.first)
			{
				current2.first = up.first;
				if (intersection2.first == up.first)
				{
					current2.second = up.second + left.second - intersection2.second;
				}
				else
				{
					current2.second = up.second + left.second;
				}
			}
			else
			{
				if (up.first < left.first)
				{
					current2.first = up.first;
					current2.second = up.second;
				}
				else
				{
					current2.first = left.first;
					current2.second = left.second;
				}
			}
		}
		else if (top_right_j + 1 >= m && bottom_left_i + 1 < n)
		{
			auto left = bottom_right_dp[bottom_left_i + 1][0];
			current2.first = left.first;
			current2.second = left.second;
		}
		else if (top_right_j + 1 < m && bottom_left_i + 1 >= n)
		{
			auto up = bottom_right_dp[0][top_right_j + 1];
			current2.first = up.first;
			current2.second = up.second;
		}
		else
		{
			current2.first = -1;
			current2.second = -1;
		}

		// Merge
		int solution;
		if (current1.first != -1 && current2.first != -1)
		{
			if (current1.first == current2.first)
			{
				solution = current1.second + current2.second;
			}
			else
			{
				if (current1.first < current2.first)
				{
					solution = current1.second;
				}
				else
				{
					solution = current2.second;
				}
			}
		}
		else if (current1.first == -1)
		{
			solution = current2.second;
		}
		else
		{
			solution = current1.second;
		}

		cout << solution << "\n";
	}
	return 0;
}